﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Text;

class MoneyServer
{
    static void Main()
    {
        const int StreamSize = 256;
        const int Port = 2010;

        var ipAddr = new IPAddress(
            new byte[] { 127, 0, 0, 1 });

        var talk = new List<string>
        {
"Ziarnko do ziarnka a zbierze się miarka",
"Grosz oszczędzony przerabia się w miliony",
"Do grosza grosz, to napełni się trzos."
       };

        var mSvr = new MoneyServer();
        var AsciiEnc = new ASCIIEncoding();
        var inStream = new byte[StreamSize];
        var outStream = new byte[StreamSize];

        Random rnd = null;
        string reqString = string.Empty;
        int index = 0;

        var tcpl = new TcpListener(ipAddr, Port);

        tcpl.Start();

        Console.WriteLine("Serwer działa...");

        do
        {
            try
            {
                Socket sock = tcpl.AcceptSocket();

                int count = sock.Receive(
                    inStream, inStream.Length, 0);
                reqString = AsciiEnc.GetString(
                    inStream, 0, count);

                Console.WriteLine(reqString);

                rnd = new Random();
                index = rnd.Next(talk.Count);

                outStream = AsciiEnc.GetBytes(
                    talk[index] as string);

                sock.Send(outStream, outStream.Length, 0);
            }
            catch (SocketException sockEx)
            {
                Console.WriteLine(
                "Komunikat o wystąpieniu błędu: {0}", 
                sockEx.ToString());
            }

        } while (reqString != "bye");

        tcpl.Stop();
    }
}
